<?php

/**
 * Dragonbyte-Tech.com Downloads Mod 1.0.0
 * 
 * @author David Tobin
 * @copyright 2010
 * @version 1.0
 * 
 * You may not copy/reproduce any part of this file in whole or significant part.
 * 
 * All rights reserved.
 */

$modcpmodule = Downloads::load_module('modcp');

$navbits[] = $vbphrase['dbtech_downloads_modcp'];

$modcp = vB_Template::create('dbtech_downloads_modcp');

$reports_query = $db->query_read("
	SELECT comments.*, filegroup.*, reports.*, user.username, user.userid FROM " . TABLE_PREFIX . "dbtech_downloads_report AS reports
	LEFT JOIN " . TABLE_PREFIX . "dbtech_downloads_comments AS comments ON (comments.comid = reports.targetid)
	LEFT JOIN " . TABLE_PREFIX . "dbtech_downloads_filegroup AS filegroup ON (filegroup.groupid = reports.targetid)
	LEFT JOIN " . TABLE_PREFIX . "user AS user ON (user.userid = reports.userid)
	ORDER BY reports.dateline DESC
");

$reports = '';
while ($report = $db->fetch_array($reports_query)) {
	$temp = vB_Template::create('dbtech_downloads_modcp_reports');
	
	if ($report['type'] == 'file' && !empty($vbulletin->options['dbtech_downloads_report_file_reasons'])) { 
		$reasons = explode('<br />', nl2br($vbulletin->options['dbtech_downloads_report_file_reasons']));
		$report['comid'] = "0";
	} else if ($report['type'] == 'comment' && !empty($vbulletin->options['dbtech_downloads_report_comment_reasons'])) {
		$reasons = explode('<br />', nl2br($vbulletin->options['dbtech_downloads_report_comment_reasons']));
		$report['groupid'] = "0";
	} else if ($report['reason'] == '999') {
		$report['comid'] = "0";
	}
	
	if (!empty($reasons)) {
		$report['reason'] = $reasons[$report['reason'] - 1];
	} else {
		if ($report['reason'] == '999') {
			$report['reason'] = $vbphrase['dbtech_downloads_broken_link'];
		} else {
			$report['reason'] = $vbphrase['dbtech_downloads_unknown'];
		}
	}
	
	$report['dateline'] = vbdate('M jS, Y', $report['dateline'], true, false);
	$report['type']		= ucfirst($report['type']);
	
	$temp->register('report', $report);
	
	$reports .= $temp->render();
}

$modcp->register('reports', $reports);

$moderation_query = $db->query_read("
	SELECT * FROM " . TABLE_PREFIX . "dbtech_downloads_filegroup
	WHERE moderation = '1'
	ORDER BY updated DESC
");

$moderation = '';
while ($queue = $db->fetch_array($moderation_query)) {
	$template = vB_Template::create('dbtech_downloads_modcp_moderation');
	
	if (strlen($queue['groupdesc']) > 300) {
		$queue['groupdesc'] = substr($queue['groupdesc'], 0, 300);
		$queue['groupdesc'] .= '...';
	}
	
	$template->register('queue', $queue);
	
	$moderation .= $template->render();
}

$modcp->register('moderation', $moderation);

$HTML .= $modcp->render();

?>